package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 会议纪要模板实体类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("cmt_meeting_record_template")
public class MeetingRecordTemplate implements Serializable {

    private static final long serialVersionUID = -26238487532381000L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;
    /**
     * 模板名称
     */
    private String name;
    
    /**
     * 模板类型（系统模板/自定义模板）
     */
    private String type;

    /**
     * 会议类型
     */
    private String meetingType;
    
    /**
     * 会议类型描述
     */
    private String typeDetail;
    
    /**
     * 提示词内容
     */
    private String prompt;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime createTime;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;
    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 更新人
     */
    private String updateUser;
    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 删除标识
     */
    private Boolean isDel;

    /**
     * 模板文件
     */
    private String template;
    /**
     * 引用的纪要模板id
     */
    private Integer referTemplateId;
    /**
     * 引用的纪要模板名称
     */
    private String referTemplateName;
}