package com.cmeeting.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;


/**
 * 返回值
 *
 * @author 王长伟
 */
@Data
@ToString
@Accessors(chain = true)
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class R implements Serializable {

    public static final int SUCCESS_CODE = 0;
    public static final int FAIL_CODE = -1;

    public static final String SUCCESS = "操作成功";
    public static final String FAIL = "操作失败";

    private String message;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Object data;

    private int code;

    public static R ok() {
        return R.builder().message(SUCCESS).build();
    }

    public static R ok(Object data) {
        return R.builder().message(SUCCESS).data(data).build();
    }

    public static R ok(int code, Object data) {
        return R.builder().message(SUCCESS).code(code).data(data).build();
    }

    public static R ok(int code, String message, Object data) {
        return R.builder().message(message).data(data).code(code).build();
    }

    public static R error() {
        return R.builder().message(FAIL).code(FAIL_CODE).build();
    }

    public static R error(String message) {
        return R.builder().message(message).code(FAIL_CODE).build();
    }

    public static R error(int code, String message) {
        return R.builder().message(message).code(code).build();
    }

    public static R error(int code, String message, Object data) {
        return R.builder().message(message).code(code).data(data).build();
    }

}
