package com.cmeeting.email;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import java.util.Properties;

public class QQMailSender {
    
    public static void sendEmailWithAttachment(String toEmail, String filePath) {
        // 发件人邮箱和授权码（不是密码）
        String from = "1960771676@qq.com";
        String password = "iaietlvcipyedjia"; // QQ邮箱的授权码
        
        // QQ邮箱SMTP服务器设置
        String host = "smtp.qq.com";
        
        // 设置属性
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true"); // 使用STARTTLS安全连接
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", "587"); // QQ邮箱的端口
        
        // 获取Session对象
        Session session = Session.getInstance(props, new Authenticator() {
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(from, password);
            }
        });
        
        try {
            // 创建邮件消息
            Message message = new MimeMessage(session);
            
            // 设置发件人
            message.setFrom(new InternetAddress(from));
            
            // 设置收件人
            message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(toEmail));
            
            // 设置邮件主题
            message.setSubject("测试发送带附件的邮件");
            
            // 创建消息体部分
            BodyPart messageBodyPart = new MimeBodyPart();
            
            // 设置消息体内容
            messageBodyPart.setText("这是一封测试邮件，包含附件。");
            
            // 创建多部分消息
            Multipart multipart = new MimeMultipart();
            
            // 设置文本消息部分
            multipart.addBodyPart(messageBodyPart);
            
            // 添加附件部分
            messageBodyPart = new MimeBodyPart();
            DataSource source = new FileDataSource(filePath);
            messageBodyPart.setDataHandler(new DataHandler(source));
            messageBodyPart.setFileName(source.getName());
            multipart.addBodyPart(messageBodyPart);
            
            // 设置完整消息
            message.setContent(multipart);
            
            // 发送邮件
            Transport.send(message);
            
            System.out.println("邮件发送成功！");
            
        } catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
    
    public static void main(String[] args) {
        // 收件人邮箱
        String toEmail = "1960771676@qq.com";
        
        // 本地文件路径
        String filePath = "D:\\5397460824645048220.docx";
        
        // 发送邮件
        sendEmailWithAttachment(toEmail, filePath);
    }
}