package com.cmeeting.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (CimcEmployee)实体类
 *
 * @author makejava
 * @since 2023-11-11 18:57:51
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CimcEmployee implements Serializable {
    private static final long serialVersionUID = 622198806836696239L;
    
    private String id;
    /**
    * 员工id
    */
    private String employeeId;
    /**
    * 办公电话
    */
    private String officePhone;
    /**
    * 本地住址
    */
    private String cityAddress;
    /**
    * 出生日期
    */
    private Date bornDate;
    /**
    * 第二外语
    */
    private String firstForeignLanguage;
    /**
    * 第二外语水平 
    */
    private String firstForeignLevel;
    /**
    * 第一外语
    */
    private String secondForeignLanguage;
    /**
    * 第一外语水平
    */
    private String secondForeignLevel;
    /**
    * 电子邮件
    */
    private String email;
    /**
    * 岗位名称
    */
    private String positionName;
    /**
    * 岗位编码
    */
    private String masterPositionId;
    /**
    * 岗位编制性质
    */
    private String positionEmpType;
    /**
    * 工种
    */
    private String positionType;
    /**
    * 公司工号
    */
    private String companyCode;
    /**
    * 公司ID
    */
    private String companyId;
    /**
    * 公司名称
    */
    private String companyName;
    /**
    * 国籍
    */
    private String nationality;
    /**
    * 户口类型
    */
    private String homeTownTypeName;
    /**
    * 户口所在地
    */
    private String homeTown;
    /**
    * 婚姻状况
    */
    private String marriageStatus;
    /**
    * 籍贯
    */
    private Object nativePlace;
    /**
    * 集团工号
    */
    private String employeeCode;
    /**
    * 家庭地址
    */
    private String homeAddress;
    /**
    * 家庭电话
    */
    private String homePhone;
    /**
    * 驾照
    */
    private String drivelicenseName;
    /**
    * 兼职岗位
    */
    private String assignPosition;
    /**
    * 兼职岗位ID
    */
    private String assignPositionId;
    /**
    * 紧急联系人 
    */
    private String fireConnectPerson;
    /**
    * 紧急联系人电话
    */
    private String firePhone;
    /**
    * 进入集团日期
    */
    private Date joinGroupDate;
    /**
    * 离职备注
    */
    private Object dismissionMemo;
    /**
    * 离职操作日期
    */
    private Date dismissonCreationDate;
    /**
    * 离职类型
    */
    private String dismissionType;
    /**
    * 离职前部门
    */
    private String dismissionUnitName;
    /**
    * 离职前岗位
    */
    private String dismissionPositionName;
    /**
    * 离职前岗位编制性质
    */
    private String dismissionEmployeeType;
    /**
    * 离职前工种
    */
    private String dismissionPositionType;
    /**
    * 离职前职能
    */
    private String dismissionJobFunction;
    /**
    * 离职前状态
    */
    private Object dismissionBeforeStatus;
    /**
    * 离职去向
    */
    private Object dismissionToPlace;
    /**
    * 离职日期
    */
    private Date dismissionDate;
    /**
    * 离职原因
    */
    private String dismissionReason;
    /**
    * 民族
    */
    private String nativeplace;
    /**
    * 母语
    */
    private String matherLanguage;
    /**
    * 迁本地户口日期
    */
    private Date toCityDate;
    /**
    * 入党日期
    */
    private Date joinPartyDate;
    /**
    * 入职日期
    */
    private Date joinDate;
    /**
    * 身份证失效日期
    */
    private Date certificateDateTo;
    /**
    * 实际转正日期
    */
    private Date formulaDate;
    /**
    * 试用结束日期
    */
    private Date trialBeginDate;
    /**
    * 试用开始日期
    */
    private Date trialEndDate;
    /**
    * 首次工作日期
    */
    private Date firstWorkDate;
    /**
    * 所属产业
    */
    private String propertyName;
    /**
    * 性别
    */
    private String sexName;
    /**
    * 姓名
    */
    private String employeeName;
    /**
    * 最高学位
    */
    private String degree;
    /**
    * 血型
    */
    private String bloodType;
    /**
    * 一级部门 
    */
    private String branchUnitName;
    /**
    * 移动电话号码
    */
    private String mobil;
    /**
    * 英文名
    */
    private String eName;
    /**
    * 员工类型
    */
    private String empType;
    /**
    * 员工状态
    */
    private String curStatusName;
    /**
    * 政治面貌
    */
    private String politicsStatus;
    /**
    * 证件编号
    */
    private String certificateId;
    /**
    * 证件类型
    */
    private String certificateType;
    /**
    * 职能
    */
    private String jobFunction;
    /**
    * 组织编码
    */
    private String unitId;
    /**
    * 组织名称  
    */
    private String unitName;
    /**
    * 最高学历
    */
    private String graduate;
    /**
    * 学校
    */
    private String collegeName;
    /**
    * 专业 
    */
    private String specialName;
    /**
    * 招聘来源id
    */
    private String govRecruitSource;
    /**
    * 招聘来源名称
    */
    private String recruitSource;
    /**
    * 创建者
    */
    private String createdBy;
    /**
    * 创建日期
    */
    private Date creationDate;
    /**
    * 最后更新者
    */
    private String lastUpdatedBy;
    /**
    * 最后更新日期
    */
    private Date lastUpdateDate;

}
