package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 会议纪要模板实体类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("cmt_meeting_record_template")
public class MeetingRecordTemplate implements Serializable {

    private static final long serialVersionUID = -26238487532381000L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 模板名称
     */
    private String name;
    
    /**
     * 模板类型（系统模板/自定义模板）
     */
    private String type;

    /**
     * 会议类型
     */
    private Long meetingType;
    
    /**
     * 模板描述
     */
    private String typeDetail;
    
    /**
     * 提示词内容
     */
    private String prompt;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date createTime;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 创建人
     */
    private String createUser;
    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 更新人
     */
    private String updateUser;
    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 删除标识，0-否(默认)，1-是
     */
    @TableLogic(delval = "1", value = "0")
    private Boolean isDel = false;

    /**
     * 模板docx文件
     */
    private String template;
    /**
     * 引用的纪要模板id
     */
    private Long referTemplateId;
    /**
     * 引用的纪要模板名称
     */
    private String referTemplateName;

    /**
     * 停启用标示，0-停用，1-启用(默认)
     */
    private Boolean enable;
}