package com.cmeeting.vo;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
;
import java.util.List;

/**
 * 会议纪要模板展示层
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class EmailPush {

    private String toEmail;
    /**
     * 收件人工号
     */
    private String toUserCode;
    /**
     * 收件人
     */
    private String toUser;
    private String subject;
    /**
     * 会议实例id（表主键）
     */
    private Integer meetingInstanceId;
    /**
     * 会议id号
     */
    private String meetingId;

    private String subMeetingId;

    /**
     * 附件
     */
    private List<Attachment> attachments;

    private Boolean emailPushAccess;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class Attachment {
        private String name;
        private byte[] bytes;
    }
}