package com.cmeeting.util;

//import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;

import cn.hutool.core.codec.Base64;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;

@Slf4j
public class AESUtils {

////    @Value("${aec.key}")
//    public static  String AES_KEY = "biaopin123456789" ;

    /**
     * AES加密+Base64转码
     *
     * @param data 明文（16进制）
     * @return
     */
    public static String encrypt(String data,String AES_KEY) {
        byte[] keyb = null;
        try {
            keyb = AES_KEY.getBytes("utf-8");
        } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        } // 明文
        SecretKeySpec sKeySpec = new SecretKeySpec(keyb, "AES");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES");
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            cipher.init(Cipher.ENCRYPT_MODE, sKeySpec);
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        byte[] bjiamihou = null;
        String miwen = "";
        try {
            bjiamihou = cipher.doFinal(data.getBytes("utf-8"));
            // byte加密后
            miwen = Base64.encode(bjiamihou);// 密文用base64加密
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (BadPaddingException e) {
            e.printStackTrace();
        } catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }

        return miwen;
    }

    /**
     * Base64解码 + AES解码
     *
     * @param data 密文 （16进制）
     * @return
     */
    public static String decrypt(String data,String AES_KEY){
        byte[] keyb = null;
        try {
            keyb = AES_KEY.getBytes("utf-8");
        } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        byte[] miwen = Base64.decode(data);
        SecretKeySpec sKeySpec = new SecretKeySpec(keyb, "AES");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES");
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            cipher.init(Cipher.DECRYPT_MODE, sKeySpec);
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        byte[] bjiemihou = null;
        String mingwen = "";
        try {
            bjiemihou = cipher.doFinal(miwen);
            // byte加密后
            mingwen = new String(bjiemihou,"utf-8");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return mingwen;
    }

    public static Boolean decryptSign(HttpServletRequest request, String AES_KEY){
        String lid = request.getHeader("lid");
        log.info("lid=============" + lid);
        String sign = request.getHeader("sign");
        log.info("sign=============" +sign);
        String decrypt = decrypt(sign, AES_KEY);
        log.info("decrypt=============" + decrypt);
        if (StringUtils.isEmpty(lid) && StringUtils.isEmpty(sign) && StringUtils.isEmpty(decrypt)){
            return true;
        }
        if(!lid.equals(decrypt)){
            log.info("----判定成功");
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        int code = 1;
        /*String[] arr = {""};
        System.out.println(Arrays.toString(arr));
        System.out.println(StringUtils.isEmpty(Arrays.toString(arr)));
        System.out.println(StringUtils.isEmpty(arr[0]));*/

//        String json = "{'username':'yanghanjing','password':'badou123456','key':'12632740','code':4,'isSaveLogin':false}";
//        JSONObject jsonObject = JSONObject.parseObject(json);
//        Map<String, Object> innerMap = jsonObject.getInnerMap();
//       System.out.println(innerMap.get("username"));

        //测试加密 feishu feishu123
//        String json = "{\"username\":\"hongdongbao1\",\"password\":\"hongdongbao123\",\"key\":\"08277992\",\"code\":"+code+",\"isSaveLogin\":false}";
        String json = "{\"username\":\"ceshi_117\",\"password\":\"ceshi123\"}";

        String miwen = encrypt(json,"biaopin123456789");// 加密
        System.out.println(miwen);

        // 测试解密工具类
        /*String  data = "ts0oGkerChzxZiOKQCkd/z5Hqvt5g9GXrLsZS0dqgCXIJAGmTgUn/Hfg6ponbjAR2WTk3u8x+VNsFtj8NKrf1hvSV7mjZoOdVHSqU9cx+qbPBi/lhBb+mBKTtuWYhG4HwoPl+NLZmCB18a4susJOfA==";
        System.out.println(decrypt(data,"biaopin123456789"));// 解密*/

        /*JSONObject ject1 = new JSONObject();
        JSONObject ject2 = new JSONObject();
        ject1.put("1",1);
        ject1.put("2",2);
        ject1.put("3",3);
        ject2.put("3",3);
        ject2.put("1",1);
        ject2.put("2",1);
        System.out.println(ject1.equals(ject2));*/
    }



}
