package com.cmeeting.exception;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @Classname BaseException
 * @Description 自定义异常
 * @Author robot
 * @Date 2019-03-29 13:21
 * @Version 1.0
 */
public class RobotBaseException extends RuntimeException implements Serializable {

    private static final long serialVersionUID = 1L;

    @Setter
    @Getter
    private String msg;

    @Setter
    @Getter
    private int code;

    public RobotBaseException(String msg) {
        super(msg);
        this.msg = msg;
    }

    public RobotBaseException(String msg, int code) {
        super(msg);
        this.msg = msg;
        this.code = code;
    }

    public RobotBaseException(String msg, Throwable e) {
        super(msg, e);
        this.msg = msg;
    }

    public RobotBaseException(String msg, Throwable e, int code) {
        super(msg, e);
        this.msg = msg;
        this.code = code;
    }


}
