package com.cmeeting.ad.vo;

import lombok.Data;
import java.util.List;

@Data
public class ApplicationUserVO {


    @Data
    public static class AddUser {
        private String id;
        String name;
        String username;
        String password;
        String applicationId;
    }

    @Data
    public static class LoginDecrypt {
        String data;

        String applicationId;

        String agentId;
    }
    @Data
    public static class Sso {
        String param;

        String applicationId;
    }
    @Data
    public static class Auth {
        String name;
        String userId;
        String applicationId;
    }

    @Data
    public static class LoginOutVO {
        String userId;

        String applicationId;
    }

    @Data
    public static class StatusVO {
        List<String> idList;
        Integer status;
    }

    @Data
    public static class DisabledVO {
        List<String> idList;
        /**
         * 0启用 1禁用
         */
        Integer disabled;
    }

    @Data
    public static class Id {
        String id;
    }

    @Data
    public static class Login {
        String username;
        String password;
        String type; //登录方式： password 密码登录    or    code  验证码登录
//        String key;
//        String code;
        String phoneCode;
    }

    @Data
    public static class ListVO {
        private String fromDate;
        /**
         * 结束日期
         */
        private String toDate;
        private Integer current;
        private Integer size;
        private String content;
        private Integer status;
        private String applicationId;
    }


    @Data
    public static class Add {
        private String name;
        private String phone;
        private String password;
        private String categoryId;
        private String applicationId;
    }

    @Data
    public static class Edit {
        private String id;
        private String name;
        private String phone;
        private String password;
        private Integer status;
    }
    @Data
    public static class BatchEdit{
        private List<String> ids;
        private Integer status;
    }

    @Data
    public static class SyncSave {
        private String applicationId;
        private List<SyncData> syncData;

        @Data
        public static class SyncData {
            private String id;      //用户id或者部门id
            private Integer type;    //0 分类  1用户
        }
    }
    @Data
    public static class BatchDelete{
        private List<String> idList;
    }
}
