package com.cmeeting.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.cmeeting.dto.UserDTO;
import com.cmeeting.pojo.MeetingRecordTemplate;
import com.cmeeting.vo.RecordTemplateVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface MeetingRecordTemplateService extends IService<MeetingRecordTemplate> {
    /**
     * 管理员可见范围的模板列表
     * @param vo
     * @return
     */
    IPage<MeetingRecordTemplate> getPage(RecordTemplateVO vo);

    /**
     * 普通用户查询个人模板列表
     * @param vo
     * @return
     */
    IPage<MeetingRecordTemplate> getPersonalPage(RecordTemplateVO vo);

    /**
     * 上传附件模板
     * @param file
     * @param id
     * @return
     */
    String templateUpload(MultipartFile file,Integer id);

    /**
     * 获取模板授权的人员
     * @return
     */
    List<UserDTO.TemplateAuthorizedUserDTO> selectAuthorizedUsers();

    /**
     * 用户下拉选择的模板列表（权限内）
     * @param vo
     * @return
     */
    List<MeetingRecordTemplate> getSelectList(RecordTemplateVO vo);
}
