package com.cmeeting.controller;

import com.cmeeting.annotation.OperLog;
import com.cmeeting.pojo.WeComUser;
import com.cmeeting.service.WeComService;
import com.cmeeting.util.R;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/wecom")
public class WeComcontroller {

    @Autowired
    private WeComService weComService;

    @GetMapping("/add")
    public void addUsers() throws Exception {
        weComService.doUsers();
    }


    /**
     * 更新个人的邮件推送许可
     * @param params
     * @return
     */
    @OperLog(location = "推送管理页面", operation = "修改是否推送")
    @PostMapping("/updateEmailPushAccess")
    public R updateEmailPushAccess(@RequestBody Map<String,Object> params) {
        if(!params.containsKey("emailPushAccess")){
            return R.error("参数缺失");
        }
        return R.ok(weComService.updateEmailPushAccess((boolean)params.get("emailPushAccess")));
    }

    /**
     * 查询个人的邮件推送许可
     * @return
     */
    @GetMapping("/findEmailPushAccess")
    public R findEmailPushAccess() {
        return R.ok(weComService.findEmailPushAccess());
    }


}