package com.cmeeting.ad.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户同步表(SysUserSync)实体类
 *
 * @author makejava
 * @since 2024-04-25 14:22:40
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("sys_user_sync")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SysUserSync implements Serializable {
    private static final long serialVersionUID = 389470942890145726L;
    /**
     * 同步用户主键id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 用户唯一标识
     */
    private String userId;
    /**
     * 用户姓名
     */
    private String name;
    /**
     * 部门id（用户同步的时候没有给这个值为默认分类）
     */
    private String deptId;
    /**
     * 别名
     */
    private String nickName;
    /**
     * 性别  0男 1女
     */
    private String gender;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 个人邮箱
     */
    private String email;
    /**
     * 部门
     */
    private String department;


}
