package com.cmeeting.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @Description
 * @Author zhang kaishi
 * @Date 2025/7/18 14:05
 **/
@Data
public class EditRecordTemplateVo {

    // 模板id
    @NotNull(message = "id不能为空", groups = {UpdateGroup.class, DeleteGroup.class, EnableGroup.class})
    private Long id;

    // 会议类型id
    @NotNull(message = "meetingTypeId不能为空", groups = {AddGroup.class})
    private Long meetingTypeId;

    // 模板名称
    @NotEmpty(message = "name不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String name;

    // 参考模板id
    private Long referTemplateId;

    // 模板描述
    @NotEmpty(message = "typeDetail不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String typeDetail;

    // 提示词
    @NotEmpty(message = "prompt不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String prompt;



    public interface AddGroup{};
    public interface UpdateGroup{};
    public interface DeleteGroup{};
    public interface EnableGroup{};
}
