package com.cmeeting.ad.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cmeeting.ad.entity.RobotSecurityUser;
import com.cmeeting.ad.service.CustomUserDetailsService;
import com.cmeeting.constant.LoginUserConstant;
import com.cmeeting.constant.UserAdminRouteConstant;
import com.cmeeting.util.HttpClientUtils;
import com.cmeeting.util.UserAdminConfig;
import com.cmeeting.util.UserAdminTokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 登录实现
 *
 * @author zw
 */
@Slf4j
@Service
public class DetailsServiceImpl implements CustomUserDetailsService {
    @Resource
    private UserAdminConfig userAdminConfig;

    /**
     * @return 用户基本信息
     * @throws UsernameNotFoundException 用户不存在
     */
    @Override
    public UserDetails loadUser(String uid, String tenantId) {
        RobotSecurityUser user = new RobotSecurityUser();
        user.setUserType(LoginUserConstant.SYS);
        String url = userAdminConfig.getUserAdminDomain() + UserAdminRouteConstant.SyncUser.INFO + "?id=" + uid + "&tenantId=" + tenantId;
        JSONObject jsonObject = HttpClientUtils.httpGet(url, UserAdminTokenUtil.getUserAdminToken());
        JSONObject data = jsonObject.getJSONObject("data");
        user.setId(data.getString("userId"));
        user.setUsername(data.getString("name"));
        user.setNick(data.getString("nickName"));
        user.setTenantId(data.getString("tenantId"));
        return user;
    }
}
