// service/UserService.java
package com.cmeeting.ad.service;


import com.cmeeting.ad.entity.RoleTree;
import com.cmeeting.ad.entity.SysMenu;
import com.cmeeting.ad.vo.ApplicationUserVO;
import com.cmeeting.ad.vo.UserVo;
import com.cmeeting.util.R;

import java.util.List;

public interface UserService {
    R login(String agentId, String data, String ip);

    String auth(String userId, String nick);

    List<String> getRoleIdByUserId(String tenantId, String userId, String path);

    /**
     * 获取登录后授权的菜单
     * @param sysMenuList
     * @return
     */
    RoleTree getLoginMenus(List<SysMenu> sysMenuList);

    Object list(String search, Integer type, Integer userType, String categoryId, Integer authType);

    Object tokenAuth(ApplicationUserVO.LoginDecrypt vo);

    Object emailAuth(UserVo.Auth vo);
}