package com.cmeeting.ad.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户同步表(SysUserSync)实体类
 *
 * @author makejava
 * @since 2024-04-25 14:22:40
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("sys_user_sync")
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SysUserSync implements Serializable {
    private static final long serialVersionUID = 389470942890145726L;
    /**
     * 同步用户主键id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 用户唯一标识
     */
    private String userId;
    /**
     * 用户姓名
     */
    private String name;
    /**
     * 姓
     */
    private String lastName;
    /**
     * 部门id（用户同步的时候没有给这个值为默认分类）
     */
    private String deptId;
    /**
     * 名
     */
    private String firstName;
    /**
     * 别名
     */
    private String nickName;
    /**
     * 性别  0男 1女
     */
    private String gender;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 个人邮箱
     */
    private String email;
    /**
     * 公司邮箱
     */
    private String companyEmail;
    /**
     * 部门
     */
    private String department;
    /**
     * 分机号
     */
    private String extensionNumber;
    /**
     * 工位
     */
    private String workStation;
    /**
     * 人员类型
     */
    private String type;
    /**
     * 国家
     */
    private String country;
    /**
     * 城市
     */
    private String city;
    /**
     * 地区
     */
    private String area;
    /**
     * 直属上级
     */
    private String directlySubordinateSuperior;
    /**
     * 虚线上级
     */
    private String dottedLineSuperior;
    /**
     * 职务
     */
    private String position;
    /**
     * 职级
     */
    private String rank;
    /**
     * 人员状态
     */
    private String state;
    /**
     * 入职日期
     */
    private String entryDate;
    /**
     * 入职类型
     */
    private String entryType;
    /**
     * 试用期
     */
    private String probationPeriod;
    /**
     * 转正日期
     */
    private String probationCompletionDate;
    /**
     * 转正状态
     */
    private String probationCompletionType;
    /**
     * 出生日期
     */
    private String birthDate;
    /**
     * 籍贯
     */
    private String nativePlace;
    /**
     * 民族
     */
    private String nationality;
    /**
     * 婚姻状况
     */
    private String maritalStatus;
    /**
     * 政治面貌
     */
    private String politicalOutlook;
    /**
     * 首次参加工作日期
     */
    private String firstWorkDate;
    /**
     * 用户信息
     */
    private Object allFieldParam;
    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    /**
     * 租户id
     */
    private String tenantId;


    @TableField(exist = false)
    private String path;
    @TableField(exist = false)
    private String deptName;

}
