package com.cmeeting.ad.entity;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.Collection;

/**
 * 登录用户信息
 *
 * @author 王长伟
 * @Date 2019-05-07 09:11
 **/
@Setter
@Getter
@Accessors(chain = true)
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RobotSecurityUser implements UserDetails {

    private static final long serialVersionUID = 1L;

    /**
     * 0系统用户 1应用用户 2通信录用户
     */
    private Integer userType;
    private String id;
    private Long userId;
    private String username;
    @JsonIgnore
    private String password;
    private String tenantId;
    /**
     *
     * 用户与租户区别字段
     */
    private Integer type;
    @JsonIgnore
    private Collection<? extends GrantedAuthority> authorities;
    private RoleTree menus;

    private SysPlatformSetting sysPlatformSetting;

    private String nick;
    private String picture;
    private String path;
    @JsonIgnore
    private boolean accountNonLocked;
    @JsonIgnore
    private boolean credentialsNonExpired;

    private String status;
    private String validity;
    private Integer reviewStatus;

    private Long kfTenantId;

    private String nickName;

    /**
     * 是否是工单客服人员
     */
    private Boolean isCustomerOrder;

    /**
     * 最大接待量
     */
    private Integer maxReception;

    /**
     * 工号
     */
    private String jobNo;

    /**
     * 是否过期
     */
    private Boolean overdue;

    private String language;

    /**
     * 返回分配给用户的角色列表
     *
     * @return
     */
    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    /**
     * 账户是否未过期,过期无法验证
     * @return
     */
    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    /**
     * 指定用户是否解锁,锁定的用户无法进行身份验证
     * @return
     */
    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    /**
     * 指示是否未过期的用户的凭据(密码),过期的凭据防止认证
     * @return
     */
    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    /**
     * 是否可用 ,禁用的用户不能身份验证
     * @return
     */
    @Override
    public boolean isEnabled() {
        return true;
    }

    public Boolean getOverdue() {
        if (StrUtil.isNotBlank(validity)){
            return DateUtil.parseDate(validity).getTime()<DateUtil.date().getTime();
        }else{
            return false;
        }
    }

    @Override
    public String toString() {
        return "RobotSecurityUser{" +
                "userType=" + userType +
                ", id='" + id + '\'' +
                ", userId=" + userId +
                ", username='" + username + '\'' +
                ", password='" + password + '\'' +
                ", tenantId='" + tenantId + '\'' +
                ", type=" + type +
                ", status='" + status + '\'' +
                ", nickName='" + nickName + '\'' +
                ", language='" + language + '\'' +
                '}';
    }
}
