package com.cmeeting.pojo;

import lombok.Data;

@Data
public class UserCompany {

    private Integer id;          // 对应表中的 `id`
    private String userName;     // 对应表中的 `user_name`
    private String phone;        // 对应表中的 `phone`
    private String email;        // 对应表中的 `emaill`（注意拼写修正为 email）
    private String address;      // 对应表中的 `address`
    private String userId;       // 对应表中的 `user_id`

    // 无参构造方法
    public UserCompany() {
    }

    // 全参构造方法
    public UserCompany(Integer id, String userName, String phone, String email, String address, String userId) {
        this.id = id;
        this.userName = userName;
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.userId = userId;
    }

    @Override
    public String toString() {
        return "UserCompany{" +
                "id=" + id +
                ", userName='" + userName + '\'' +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                ", address='" + address + '\'' +
                ", userId='" + userId + '\'' +
                '}';
    }
}