package com.cmeeting.ad.controller;

import com.cmeeting.ad.service.UserService;
import com.cmeeting.ad.vo.ApplicationUserVO;
import com.cmeeting.ad.vo.UserVo;
import com.cmeeting.util.IPUtils;
import com.cmeeting.util.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("/admin")
public class UserAdminController {

    @Autowired
    private UserService userService;

    /**
     * 授权查询接口
     * @param search
     * @param type
     * @param userType
     * @param categoryId
     * @param authType
     * @return
     */
    @GetMapping("/user/list")
    public R list(String search, @RequestParam Integer type, @RequestParam Integer userType,
                   String categoryId, Integer authType) {
        return R.ok(userService.list(search, type, userType, categoryId, authType));
    }
}