package com.cmeeting.constant;

/**
 * @author liuzhenmeng
 * @date 2024/6/27 19:43
 */
public interface KnowledgePlatformRouteConstant {

    /**
     * 文档库相关接口路由
     */
    interface DocLibrary {

        /**
         * 新增文档库
         */
        String ADD_DOC_LIBRARY_URL = "/docLibrary/add";

        /**
         * 编辑文档库
         */
        String EDIT_DOC_LIBRARY_URL = "/docLibrary/edit";

        /**
         * 删除文档库
         */
        String REMOVE_DOC_LIBRARY_URL = "/docLibrary/delete";

        /**
         * 文档库详情
         */
        String DOC_LIBRARY_INFO_URL = "/docLibrary/info";

        /**
         * 文档库列表
         */
        String DOC_LIBRARY_LIST_URL = "/docLibrary/list";

        /**
         * 获取用户文档库权限
         */
        String DOC_LIBRARY_AUTHORITY_URL = "/docLibrary/authority";

        /**
         * 查询用户所有有权限的文档库
         */
        String DOC_LIBRARY_ALL_URL = "/docLibrary/all";

        /**
         * 文档库授权列表查询
         */
        String DOC_LIBRARY_AUTH_LIST_URL = "/docLibrary/authList";

        /**
         * 文档库授权
         */
        String DOC_LIBRARY_AUTH_URL = "/docLibrary/auth";

        /**
         * 移除文档库授权
         */
        String DOC_LIBRARY_AUTH_REMOVE_URL = "/docLibrary/removeAuth";
        String DOC_LIBRARY_AUTH_REMOVE_BY_RELID_URL = "/docLibrary/removeAuthByRelId";
        String DOC_LIBRARY_AUTH_REMOVE_BY_RELIDS_URL = "/docLibrary/removeAuthByRelIds";
        /**
         * 咨询窗获取个人库和系统库分类id
         */
        String DOC_LIBRARY_SYS_AND_PERSONAL_CATEGORY_URL = "/docLibrary/getSysAndPersonalCategoryId";

        /**
         * 修改分类文档名称
         */
        String DOC_LIBRARY_UPDATE_CATEGORY_OR_DOC_NAME_URL = "/docLibrary/updateCategoryOrDocName";

        /**
         * 文档库数据报告
         */
        String DOC_LIBRARY_REPORT_URL = "/docLibrary/getDocLibraryReportByTenant";

        /**
         * 个人库数据报告
         */
        String PERSON_DOC_LIBRARY_REPORT_URL = "/docLibrary/getPersonDocLibraryReport";

        /**
         * 文档库权限设置
         */
        String DOC_LIBRARY_PURVIEW_SET_URL = "/docLibraryPurview/set";

        /**
         * 文档库权限详情
         */
        String DOC_LIBRARY_PURVIEW_INFO_URL = "/docLibraryPurview/info";

    }

    /**
     * 文档分类相关接口路由
     */
    interface DocCategory {

        /**
         * 创建文档分类
         */
        String DOC_CATEGORY_ADD_URL = "/category/add";

        /**
         * 编辑文档分类
         */
        String DOC_CATEGORY_EDIT_URL = "/category/edit";

        /**
         * 文档分类详情
         */
        String DOC_CATEGORY_INFO_URL = "/category/info";

        /**
         * 删除文档分类
         */
        String DOC_CATEGORY_REMOVE_URL = "/category/delete";

        /**
         * 文档分类树
         */
        String DOC_CATEGORY_TREE_URL = "/category/tree";
        /**
         * 文档分类list
         */
        String DOC_CATEGORY_LIST_URL = "/category/list";

        /**
         * 分类查询分类和文档树
         */
        String DOC_CATEGORY_DOC_TREE_URL= "/category/docAndCategoryTree";

        /**
         * 分类查询分类和文档分页
         */
        String DOC_CATEGORY_PAGE_URL = "/category/getDocAndCategoryPage";
        String DOC_PAGE_URL = "/category/getDoc";

        /**
         * 个人库一级分类
         */
        String PERSON_LIBRARY_LEVEL_CATEGORY_URL = "/category/personLibraryLevelCategory";

        /**
         * 获取当前分类的父类顺序list
         */
        String DOC_CATEGORY_SORT_LIST_URL = "/category/getCategorySortList";

        /**
         * 获取分享分类list
         */
        String DOC_CATEGORY_SHARE_LIST_URL = "/category/getShareCategory";

        /**
         * 个人库分类文档
         */
        String PERSON_TREE_URL = "/category/personLibraryTree";

        /**
         * 文档分类list
         */
        String DOC_CATEGORY_LIST_IDS_URL = "/category/listByCategoryIds";

        /**
         * 文档分类list
         */
        String DOC_CATEGORY_MOVE_URL = "/category/move";

    }

    /**
     * 文档操作相关接口路由
     */
    interface DOC {

        /**
         * 新增文档
         */
        String DOC_ADD_URL = "/doc/add";

        /**
         * 编辑文档
         */
        String DOC_EDIT_URL = "/doc/edit";

        /**
         * 文档停启用
         */
        String DOC_ENABLED_URL = "/doc/enabled";

        /**
         * 上传文档
         */
        String DOC_UPLOAD_URL = "/doc/upload";

        /**
         * 删除文档
         */
        String DOC_DELETE_URL = "/doc/delete";

        /**
         * 文档详情
         */
        String DOC_INFO_URL = "/doc/info";

        /**
         * 获取文档详情包含附件文档用户鉴权
         */
        String DOC_FILE_INFO_URL = "/doc/fileInfo";

        /**
         * 文档移动
         */
        String DOC_MOVE_URL = "/doc/move";

        /**
         * 修改文档信息
         */
        String DOC_MODIFY_URL = "/doc/modify";

        /**
         * 文档同步/取消同步
         */
        String DOC_SYNC_URL = "/doc/synchronization";

        /**
         * 文档批量同步
         */
        String DOC_BATCH_SYNC_URL = "/doc/batchSync";

        /**
         * 根据条件批量同步文档
         */
        String DOC_BATCH_SYNC_BY_PARAM = "/doc/batchSyncDocByParam";

        /**
         * 获取文档列表
         */
        String DOC_LIST_URL = "/doc/list";
        /**
         * 获取文档列表分页
         */
        String DOC_LIST_BY_PAGE_URL = "/doc/listByPage";

        /**
         * 获取有权限的所有文档
         */
        String DOC_AUTH_ALL_URL = "/doc/all";

        /**
         * 对接文档上传文件接口
         */
        String SIMPLE_DOC_UPLOAD_URL = "/doc/simpleDocUpload";

        /**
         * 获取onlyoffice配置
         */
        String ONLYOFFICE_FILE_CONFIG_URL = "/onlyoffice/getFileKey";

        /**
         * 模糊查询所有权限库的doc
         */
        String DOC_SEARCH_FUZZY_LIST_URL = "/doc/searchFuzzyDocList";
        /**
         * DOC统计信息
         */
        String DOC_PLATFORM_DOC_INFO_URL = "/doc/getPlatformDocInfoByTenantId";
        /**
         * 文档分享数据
         */
        String DOC_SHARE_DOC_NUM_INFO_URL = "/doc/getShareDocNumInfo";
        /**
         *咨询窗根据分类查找子级分类和文档
         */
        String DOC_AND_CATEGORY_BY_CATEGORYID_URL = "/doc/getDocsAndCategoriesByCategoryId";

        /**
         * 新增附件文档
         */
        String DOC_ADD_ATTACH_URL = "/doc/addAttachDoc";

        /**
         * 编辑附件文档
         */
        String DOC_EDIT_ATTACH_URL = "/doc/editAttachDoc";
        /**
         * 上传附件
         */
        String DOC_UPLOAD_ATTACH_URL = "/doc/uploadAttach";

        /**
         * 获取文件路径(包含附件)
         */
        String DOC_GET_FILE_PATH = "/doc/getFilePath";

        /**
         * 获取文档路径详情接口
         */
        String DOC_CATEGORY_INFO_URL = "/doc/getDocInfoByLibraryId";
        String MD_INFO = "/doc/mdInfo";
        String EDIT_MD = "/doc/editMD";
        String DOC_AUTH="/doc/auth";

        /**
         * 根据文件分类id集合获取文件id集合
         */
        String DOC_GET_ALL_FILE_ID_URL = "/doc/getDocIdListByCategoryIdList";
        String Check_MD_Language = "/doc/checkMdLanguage";

        /**
         * 获取当前租户下所有文档不同的状态的数量
         */
        String DOC_GET_SYNC_COUNT = "/doc/getDocSyncStatusCountList";
        String PUT_META_DATA = "/doc/putMetaData";
        String COUNT_EXIST_DOC = "/doc/countExistDoc";
        String DOC_ALL_LIST = "/doc/getDocListByVO";
    }

    interface KNOWLEDGE {
        /**
         * 知识库查询接口
         */
        String KNOWLEDGE_TREE_URL = "/category/knowledge/tree";
    }

    interface SEARCH {

        /**
         * 搜索接口
         */
        String MILVUS_SEARCH_URL = "/search";

        /**
         * 高级搜索
         */
        String MILVUS_LLM_SEARCH_URL = "/llmSearch";

        /**
         * 知识采编搜索
         */
        String KNOWLEDGE_COLLECT_SEARCH_URL = "/knowledgeCollectSearch";

        /**
         * embedding模型更换
         */
        String EMBEDDING_CHANGE_URL = "/embeddingModel/change";

        /**
         * 获取答案来源切片
         */
        String GET_ANSWER_SOURCE_URL = "/getAnswerSource";

        /**
         * 片段搜索
         */
        String PARA_SEARCH_URL = "/searchParaByDocIds";
        String CONTENT_SEARCH_URL = "/searchContentByDocIds";
    }

    interface KNOWLEDGECOLLECT {

        /**
         * 知识采编同步文档
         */
        String KNOWLEDGE_COLLECT_SYNC_DOC_URL = "/knowledgeCollect/syncDoc";

        /**
         * 知识采编删除文档向量
         */
        String KNOWLEDGE_COLLECT_DELETE_DOC_VECTOR_URL = "/knowledgeCollect/deleteDocVector";

        /**
         * 删除问题向量
         */
        String KNOWLEDGE_COLLECT_DELETE_DOC_QUESTION_URL = "/knowledgeCollect/deleteDocVector";

        /**
         * 同步文档
         */
        String SYNC_GENERATE_QUESTION_URL = "/knowledgeCollect/syncGenerateQuestions";

    }

    interface RELDOCVEC {

        /**
         * 查询切片向量列表
         */
        String FIND_REL_DOC_VEC_LIST_URL = "/relDocVec/findByIds";
    }

    interface SYNC {

        /**
         * 查询切片向量列表
         */
        String SYNC_FAQ_URL = "/faq/syncQa";

        /**
         * 删除知识点向量
         */
        String DELETE_QA_VEC_URL = "/faq/deleteQaVec";
    }
    interface ES {
        String QUERY = "/es/api/search";
        String PURE_QUERY = "/es/api/search/pureEs";
        String RELOAD = "/es/api/reload";
    }

    interface TAG {
        String ADD = "/tag/add";
        String EDIT = "/tag/edit";
        String DELETE = "/tag/delete";
        String LIST = "/tag/list";
        String DETAIL = "/tag/detail";
        String DATA_LIST = "/tag/dataList";
    }

}
