package com.cmeeting.config;

import cn.hutool.core.date.DateUtil;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import java.beans.PropertyEditorSupport;
import java.util.Date;

/**
 * @Description 全局控制器增强器
 * @Author zhang kaishi
 * @Date 2025/7/17 17:29
 **/
@RestControllerAdvice
public class GlobalControllerAdvice {

    @InitBinder
    public void initBinder(WebDataBinder binder)
    {
// Date 类型转换
        binder.registerCustomEditor(Date.class, new PropertyEditorSupport()
        {
            @Override
            public void setAsText(String text)
            {
                setValue(ObjectUtils.isEmpty(text) ? null : DateUtil.parse(text));
            }
        });
    }
}

