package com.cmeeting.ad.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.cmeeting.ad.entity.RobotSecurityUser;
import com.cmeeting.ad.entity.SysUserSync;
import com.cmeeting.ad.service.CustomUserDetailsService;
import com.cmeeting.constant.UserTypeConstant;
import com.cmeeting.service.SysUserSyncService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 登录实现
 *
 * @author zw
 */
@Slf4j
@Service
public class DetailsServiceImpl implements CustomUserDetailsService {
    @Resource
    private SysUserSyncService sysUserSyncService;

    /**
     * @return 用户基本信息
     * @throws UsernameNotFoundException 用户不存在
     */
    @Override
    public UserDetails loadUser(String uid, String tenantId, String role) {
        RobotSecurityUser user = new RobotSecurityUser();
        user.setUserType(UserTypeConstant.SYNC);
        SysUserSync one = sysUserSyncService.getOne(new LambdaQueryWrapper<SysUserSync>().eq(SysUserSync::getUserId, uid).last("limit 1"));
        user.setId(one.getUserId());
        user.setUserId(Long.valueOf(one.getUserId()));
        user.setUsername(one.getName());
        user.setNick(one.getName());
        user.setRole(role);
        return user;
    }
}
