package com.cmeeting.email;


import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.models.*;
import com.microsoft.graph.requests.GraphServiceClient;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

import java.io.*;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;

public class AzureADEmailSender {

    public static void main(String[] args) throws IOException {
//d65aa91b-05f4-42b2-902f-4d82ea5a2b93
        //~N98Q~83v6dViQFIofwr0fRn4J5VEZ2tvwOz.bPX
        //74cc8acf-aacc-4514-9bbb-dc27ce3096bb

        /**中集
         * c06fe7cf-2a89-4099-9805-ce03031938f8
         * wsu8Q~GxYxPLf2akioQZDRG8NR1EzCAHIAQRVc6u
         * 18653b3e-03c7-499e-8baf-42ef06a814ef
         */
        ClientSecretCredential clientSecretCredential = new ClientSecretCredentialBuilder()
                .clientId("d65aa91b-05f4-42b2-902f-4d82ea5a2b93")
                .clientSecret("~N98Q~83v6dViQFIofwr0fRn4J5VEZ2tvwOz.bPX")
                .tenantId("74cc8acf-aacc-4514-9bbb-dc27ce3096bb")
                .build();
        final TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(Arrays.asList("https://graph.microsoft.com/.default"), clientSecretCredential);
        System.out.println("First Step Reached. ");
        buildDraftMessage(tokenCredAuthProvider);
    }


    private static final long MB = 1024 * 1024;
    //binzhai321@outlook.com
    //cmeeting_assistant@cimc.com
    private static final String  SENDER_MAIL = "binzhai321@outlook.com";
    private static final String  RECIPIENT_MAIL = "binzhai321@outlook.com";


    public static void buildDraftMessage(TokenCredentialAuthProvider authProvider) throws IOException {
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider(authProvider).buildClient();
        Message message = new Message();
        message.subject = "Did you see last night's game?";
        ItemBody body = new ItemBody();
        body.contentType = BodyType.HTML;
        body.content = "They were <b>awesome</b>!";
        message.body = body;
        LinkedList<Recipient> toRecipientsList = new LinkedList<Recipient>();
        Recipient toRecipients = new Recipient();
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.address = RECIPIENT_MAIL;
        toRecipients.emailAddress = emailAddress;
        toRecipientsList.add(toRecipients);
        message.toRecipients = toRecipientsList;
        //构建草稿
        Message post = graphClient.users(SENDER_MAIL).messages()
                .buildRequest()
                .post(message);
        //构建附件
        buildAttach(authProvider, post);
        //发送草稿邮件
        graphClient.users(SENDER_MAIL).messages(post.id)
                .send()
                .buildRequest()
                .post();
    }

    private static void buildAttach(IAuthenticationProvider authProvider, Message message) throws IOException {
        File file = new File("path");
        FileInputStream fileInputStream = new FileInputStream(file);
        int available = fileInputStream.available();
        if (available >= 3 * MB) {
            //附件大于3M，使用大附件专用发送方法
            bigAttach(authProvider, message, file);
        } else {
            //附件小于3M，使用普通发送方法
            commonAttach(authProvider, message, fileInputStream);
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024 * 4];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }


    private static void commonAttach(IAuthenticationProvider authProvider, Message message, FileInputStream fileInputStream) throws IOException {
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider(authProvider).buildClient();
        FileAttachment attachment = new FileAttachment();
        attachment.oDataType = "#microsoft.graph.fileAttachment";
        attachment.name = "smile.pdf";
        attachment.contentBytes = toByteArray(fileInputStream);

        graphClient.users(SENDER_MAIL).messages(message.id).attachments()
                .buildRequest()
                .post(attachment);
    }

    public static void bigAttach(IAuthenticationProvider authProvider, Message message, File file) throws IOException {
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider(authProvider).buildClient();

        FileInputStream fileInputStream = new FileInputStream(file);
        int available = fileInputStream.available();
        AttachmentItem attachmentItem = new AttachmentItem();
        attachmentItem.attachmentType = AttachmentType.FILE;
        attachmentItem.name = "flower.pdf";
        attachmentItem.size = (long) available;
        UploadSession uploadSession = graphClient.users(SENDER_MAIL).messages(message.id).attachments()
                .createUploadSession(AttachmentCreateUploadSessionParameterSet
                        .newBuilder()
                        .withAttachmentItem(attachmentItem)
                        .build())
                .buildRequest()
                .post();
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse("application/octet-stream");
        RequestBody body = RequestBody.create(mediaType, file);
        okhttp3.Request request = new okhttp3.Request.Builder()
                .url(uploadSession.uploadUrl)
                .method("PUT", body)
                .addHeader("Content-Length", String.valueOf(attachmentItem.size))
                .addHeader("Content-Range", "bytes 0-" + (attachmentItem.size - 1) + "/" + attachmentItem.size)
                .addHeader("Content-Type", "application/octet-stream")
                .build();
        Response response = client.newCall(request).execute();
        System.out.println(response.body().string());

    }
}