// vo/LoginVO.java
package com.cmeeting.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
public class TencentMeetingVO {

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class TencentMeetingRequest{
        private Long startTime; //开始结束时间戳
        private Long endTime;
        private Integer pageSize;
        private Integer page;
        private String operatorId;
        private Integer operatorIdType;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class RecordFile{
        private String meetingId;//如果是周期会议，这个id表示主会议
        private String subMeetingId;//如果是周期会议，这个id表示子会议
        private List<String> recordFileIdList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class SimpleMeetingInfo{
        private String meetingId;//如果是周期会议，这个id表示主会议
        private String subMeetingId;//如果是周期会议，这个id表示子会议

        private String recordFileId;// 会议记录id，多个以","分隔
    }
}