package com.cmeeting.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 中集·组织·标准信息(CimcOrganization)实体类
 *
 * @author makejava
 * @since 2023-11-11 17:06:35
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CimcOrganization implements Serializable {
    private static final long serialVersionUID = -81161130857632176L;
    
    private String id;
    /**
    * 组织id
    */
    private String unitId;
    /**
    * 组织名称
    */
    private String unitName;
    /**
    * 父组织id
    */
    private String parentId;
    /**
    * 组织管理岗位名称
    */
    private String managerPositionName;
    /**
    * 组织级别id
    */
    private String levelId;
    /**
    * 组织级别名称
    */
    private String levelName;
    /**
    * 组织描述
    */
    private String unitDescription;
    /**
    * 公司id
    */
    private String companyId;
    /**
    * 公司名称
    */
    private String companyName;
    /**
    * 顺序号
    */
    private String searchIndex;
    /**
    * 是否公司管理层
    */
    private String isMgmtUnit;
    /**
    * 干部管理权责
    */
    private String isOwnedUnit;
    /**
    * 创建者id
    */
    private String createdBy;
    /**
    * 创建日期
    */
    private Date creationDate;
    /**
    * 最后修改者
    */
    private String lastUpdatedBy;
    /**
    * 最后修改日期
    */
    private Date lastUpdateDate;
    /**
    * 组织管理岗位ID
    */
    private String managerPosition;

}
