package com.cmeeting.controller;

import com.cmeeting.pojo.OperationLog;
import com.cmeeting.service.OperationLogService;
import com.cmeeting.util.R;
import com.cmeeting.util.page.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

@Slf4j
@RequestMapping("/operLog")
@RestController
public class OperationLogController {

    @Autowired
    private OperationLogService operationLogService;

    /**
     * 获取操作日志列表
     * @param searchValue     用户姓名/员工号
     * @param createTimeStart 开始时间
     * @param createTimeEnd   结束时间
     * @return
     */
    @GetMapping("/list")
    public R list(Integer current, Integer size, String searchValue, Date createTimeStart, Date createTimeEnd) {

        current = ObjectUtils.isEmpty(current) ? 1 : current;
        size = ObjectUtils.isEmpty(size) ? 10 : size;

        PageUtil.startPage(size, current, "id desc");

        List<OperationLog> list = operationLogService.list(searchValue, createTimeStart, createTimeEnd);

        return PageUtil.getDataTable(list);
    }
}
