package com.cmeeting.controller;

import com.cmeeting.annotation.OperLog;
import com.cmeeting.constant.MeetingTypeConstant;
import com.cmeeting.dto.MeetTypeDto;
import com.cmeeting.service.MeetTypeService;
import com.cmeeting.util.R;
import com.cmeeting.vo.MeetingTypeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description
 * @Author zhang kaishi
 * @Date 2025/7/18 9:47
 **/
@RestController
@RequestMapping("/meetingType")
public class MeetingTypeController {

    @Autowired
    private MeetTypeService meetTypeService;

    /**
     * 新增会议类型
     * @param meetingTypeVo 请求参数
     */
    @OperLog(location = "系统模板页", operation = "新增会议类型")
    @PostMapping("/add")
    public R add(@RequestBody @Validated(MeetingTypeVo.AddGroup.class) MeetingTypeVo meetingTypeVo) {
        meetTypeService.add(meetingTypeVo);
        return R.ok();
    }

    /**
     * 更新会议类型
     * @param meetingTypeVo 请求参数
     */
    @OperLog(location = "系统模板页", operation = "更新会议类型")
    @PostMapping("/update")
    public R update(@RequestBody @Validated(MeetingTypeVo.UpdateGroup.class) MeetingTypeVo meetingTypeVo) {
        meetTypeService.update(meetingTypeVo);
        return R.ok();
    }

    /**
     * 删除会议类型
     * @param meetingTypeVo 请求参数
     */
    @OperLog(location = "系统模板页", operation = "删除会议类型")
    @PostMapping("/delete")
    public R delete(@RequestBody @Validated(MeetingTypeVo.DeleteGroup.class) MeetingTypeVo meetingTypeVo) {

        meetTypeService.delete(meetingTypeVo.getId());

        return R.ok();
    }

    /**
     * 会议类型列表
     */
    @GetMapping("/list")
    public R list() {

        List<MeetTypeDto> list =  meetTypeService.getMeetTypeList();

        return R.ok(list);
    }

    /**
     * 获取会议类型下拉框
     */
    @GetMapping("/select")
    public R select() {

        List<MeetTypeDto> list =  meetTypeService.getMeetTypeSelect();

        return R.ok(list);
    }
}
