package com.cmeeting.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 会议纪要模板展示层
 */
@Data
public class MeetingInfoVO {

    /**
     * 当前页
     */
    private Integer current;

    /**
     * 每页最大数据行
     */
    private Integer size;
    /**
     * 主键id
     */
    @NotNull
    private Integer id;
    /**
     * 会议主题
     */
    private String subject;

    /**
     * 会议ID（字符串类型）
     */
    private String meetingId;

    /**
     * 子会议ID
     */
    private String subMeetingId;

    /**
     * 会议号码
     */
    private String meetingCode;

    /**
     * 主持人
     */
    private String host;

    /**
     * 主持人uid
     */
    private String hostUid;

    /**
     * 参会人员名单
     */
    private String participantUsers;

    /**
     * 会议开始时间（时间戳）
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime startTime;

    /**
     * 会议结束时间（时间戳）
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime endTime;

    /**
     * 是否生成会议纪要完成
     */
    private Boolean isGenerated;
    /**
     * 推送邮件许可 为false不推送
     */
    private Boolean emailPushAccess;
    /**
     * 是否推送邮件完成
     */
    private Boolean isPushed;
    /**
     * 会议纪要重新生成标识
     */
    private Boolean generateRetry;
    /**
     * 邮件推送重试标识
     */
    private Boolean pushRetry;
    private Boolean reprocess;
    /**
     * 同步时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime syncTime;

    /**
     * 转录文本
     */
    private String recordContent;

    /**
     * 纪要xml
     */
    private String recordXml;
    /**
     * 每个会议对应的转录文件id，多个用逗号分隔,按参会前后升序
     */
    private String recordFileId;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 同步时间
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime updateTime;

    /**
     * 模板ID
     */
    private Integer templateId;
    /**
     * 会议纪要json
     */
    private String recordJson;
    /**
     * 用户信息
     */
    private String userId;

    private String applicationId;
    /**
     * 转录文件知识库id
     */
    private String transDocId;
}