package com.cmeeting.util;

import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;

public class JasyptUtilTest {

    public static String password = "EbfYkitulv23I2p1mXI50JMXoaxZTKJ7";

    public static String algorithm = "PBEWITHMD5ANDDES";

    /**
     * 加密方法
     *
     * @param value 需要加密的值
     * @return
     */
    public static String encyptPwd(String value) {
        //1.创建加密工具实例
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        //2.加解密配置
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(password);
        config.setAlgorithm(algorithm);
        //3.为了减少配置文件的书写，以下都是jasyp 3.x版本，配置文件默认配种
        config.setKeyObtentionIterations("1000");
        config.setPoolSize("1");
        config.setProviderName("SunJCE");
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setStringOutputType("base64");
        encryptor.setConfig(config);
        return encryptor.encrypt(value);
    }


    public static String decryptPwd(String value) {
        //1.创建加密工具实例
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        //2.加解密配置
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(password);
        config.setAlgorithm(algorithm);
        //3.为了减少配置文件的书写，以下都是jasyp 3.x版本，配置文件默认配种
        config.setKeyObtentionIterations("1000");
        config.setPoolSize("1");
        config.setProviderName("SunJCE");
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setStringOutputType("base64");
        encryptor.setConfig(config);
        return encryptor.decrypt(value);
    }

    public static void main(String[] args) {
        String en = encyptPwd("scyou@xih45g6@xih4");
        System.out.println(en);

    }
}
