package com.cmeeting.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cmeeting.constant.CimcConstants;
import com.cmeeting.dto.CimcEmployee;
import com.cmeeting.dto.CimcOrganization;
import com.cmeeting.dto.CimcPost;
import com.cmeeting.exception.RobotBaseException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * 中集相关接口工具类
 */
@Slf4j
@Component
public class CimcUtil implements CimcConstants {

    @Value("${cimc.username}")
    public String username;
    @Value("${cimc.password}")
    public String password;
    @Value("${cimc.apiKey}")
    public String apiKey;

    @Value("${cimc.userinfo-environment}")
    public String userInfoEnvironment;

    public void testSSLTimeout(int pageNum, Class zClass) {
        String uri = "";
        if (CimcEmployee.class == zClass) {
            if ("test".equals(userInfoEnvironment)) {
                uri = GET_TEST_EMPLOYEE;
            } else {
                uri = GET_AWS_EMPLOYEE;
            }
        } else if (CimcOrganization.class == zClass) {
            if ("test".equals(userInfoEnvironment)) {
                uri = GET_TEST_ORGANIZATION;
            } else {
                uri = GET_AWS_ORGANIZATION;
            }
        } else if (CimcPost.class == zClass) {
            if ("test".equals(userInfoEnvironment)) {
                uri = GET_TEST_POSITION;
            } else {
                uri = GET_AWS_POSITION;
            }
        }
        String url = uri.replace(ALTER_USER, URLEncoder.encode(username)).replace(ALTER_PASSWORD, URLEncoder.encode(password)).replace(ALTER_API_KEY, apiKey).replaceAll(ALTER_PAGE_NUM, String.valueOf(pageNum));
        String res = SSLUtils.sendGetByHttpsAndTtimOut(url);
        if (res.contains("You cannot consume this service")) {
            log.error("同步信息失败，账号或apiKey无效");
        }
        if (res != null) {
            log.info("res.length: {}", res.length());
            if (res.length() < 1000) {
                log.info("res: \n{}", res);
            }
        } else {
            log.info("res is null");
        }
    }


    public List getDataByClass(int pageNum, Class zClass) {
        String recordsName = "";
        String uri = "";
        if (CimcEmployee.class == zClass) {
            if ("test".equals(userInfoEnvironment)) {
                uri = GET_TEST_EMPLOYEE;
            } else {
                uri = GET_AWS_EMPLOYEE;
            }
            recordsName = "employee_record";
        } else if (CimcOrganization.class == zClass) {
            if ("test".equals(userInfoEnvironment)) {
                uri = GET_TEST_ORGANIZATION;
            } else {
                uri = GET_AWS_ORGANIZATION;
            }
            recordsName = "unit_record";
        } else if (CimcPost.class == zClass) {
            if ("test".equals(userInfoEnvironment)) {
                uri = GET_TEST_POSITION;
            } else {
                uri = GET_AWS_POSITION;
            }
            recordsName = "position_record";
        }
        String url = uri.replace(ALTER_USER, URLEncoder.encode(username)).replace(ALTER_PASSWORD, URLEncoder.encode(password)).replace(ALTER_API_KEY, apiKey).replaceAll(ALTER_PAGE_NUM, String.valueOf(pageNum));
        String res = SSLUtils.sendGetByHttpsAndTtimOut(url);
        if (res.contains("You cannot consume this service")) {
            throw new RobotBaseException("同步信息失败，账号或apiKey无效");
        }

        if (res.length() < 2000) {
            log.error("res: {}", res);
        }
        JSONObject object = JSONObject.parseObject(res);
        JSONObject envelope = (JSONObject) object.get("soap:Envelope");
        JSONObject body = (JSONObject) envelope.get("soap:Body");
        JSONObject records = null;
        records = (JSONObject) body.get(recordsName);
        if (records == null) {
            return null;
        }
        JSONArray record = (JSONArray) records.get("record");
        if (record == null) {
            return null;
        }
        List<Object> objectList = new ArrayList<>();
        // 提供的AD账号和密码对应一个租户
        if (record.size() != 0) {
            record.forEach(obj -> {
                Object o = JSONObject.toJavaObject((JSONObject) obj, zClass);
                objectList.add(o);
            });
        }
        return objectList;
    }


}
