package com.cmeeting.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 会议纪要模板展示层
 */
@Data
public class RecordTemplateVO {

    /**
     * 主键id
     */
    private Integer id;

    /**
     * 模板名称
     */
    private String name;
    
    /**
     * 模板类型（系统模板 system/自定义模板 custom）
     */
    private String type;

    /**
     * 会议类型
     */
    private String meetingType;
    
    /**
     * 会议类型描述
     */
    private String typeDetail;

    /**
     * 当前页
     */
    private Integer current;

    /**
     * 每页最大数据行
     */
    private Integer size;

    /**
     * 创建人查询条件
     */
    private String createUser;

    /**
     * 时间查询条件开始
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime startTime;

    /**
     * 时间查询条件结束
     */
    @DateTimeFormat(pattern = "yyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private LocalDateTime endTime;

    @Data
    public static class TemplatePermissionVO{
        /**
         * 模板id
         */
        private Integer templateId;
        /**
         * 选中的部门或人员
         */
        private List<PermissionItem> permissionItems;

    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class PermissionItem{
        /**
         * 对象类型
         */
        private String relType;
        /**
         * 关联对象id
         */
        private String relId;
        /**
         * 关联对象
         */
        private String relName;
    }

    @Data
    public static class TemplateAuthVO{
        /**
         * 模板id
         */
        private Integer templateId;

        /**
         * 当前页
         */
        private Integer current;

        /**
         * 每页最大数据行
         */
        private Integer size;

    }
}