package com.cmeeting.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.util.Date;

@Data
public class RecordTemplateDto {
    // 模板id
    private Long id;
    // 模板名称
    private String name;
    // 模板类型
    private String type;
    // 模板描述
    private String typeDetail;
    // 生成模板的提示词
    private String prompt;
    // 模板文件
    private String template;
    // 引用（参考）模板id
    private Long referTemplateId;
    // 创建者工号
    private String createUser;
    // 创建者姓名
    private String createUserName;
    // 模板创建时间，格式：yyyy-MM-dd HH:mm:ss
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    // 是否启用
    private Boolean enable;

    // 会议类型名称
    private String meetingTypeName;
}