package com.cmeeting.ad.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 平台设置表(SysPlatformSetting)实体类
 *
 * @author makejava
 * @since 2023-06-12 11:43:45
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("sys_platform_setting")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysPlatformSetting implements Serializable {
    private static final long serialVersionUID = -86441288874834748L;
    /**
    * 主键id
    */
    private String id;
    /**
    * 是否使用机器人 0：false 1：true, 默认为1
    */
    private Integer robot;
    /**
    * 是否使用数字人 0：false 1：true, 默认为1
    */
    private Integer digitalPerson;
    /**
    * 是否使用客服系统 0：false 1：true ，默认为1
    */
    private Integer moduleKefu;
    /**
    * 是否使用大语言模型 0：false 1：true ，默认为1
    */
    private Integer largeLanguage;
    /**
    * 是否使用工单系统 0：false 1：true ， 默认为1
    */
    private Integer moduleTicket;
    /**
    * 是否使用问答知识点 0：false 1：true, 默认为1
    */
    private Integer qaKnowledge;
    /**
    * 是否使用知识导图 0：false 1：true, 默认为1
    */
    private Integer atlasKnowledge;
    /**
    * 是否使用多轮对话 0：false 1：true ，默认为1
    */
    private Integer dialogKnowledge;
    /**
    * 是否使用文档知识点 0：false 1：true ， 默认为1
    */
    private Integer docKnowledge;
    /**
    * logo登录标签地址
    */
    private String loginLogoUrl;
    /**
    * logo首页标签地址
    */
    private String indexLogoUrl;
    /**
    * 背景图片地址
    */
    private String backgroundUrl;
    /**
    * 推广图片地址
    */
    private String advertiseUrl;
    /**
    * 底部信息
    */
    private String bottomInfo;
    /**
    * 创建时间;创建时间
    */
    private Date createTime;
    /**
    * 更新时间;更新时间
    */
    private Date updateTime;
    /**
    * 创建人;创建人id
    */
    private String createUser;
    /**
    * 更新人;更新人id
    */
    private String updateUser;
    /**
    * 删除标识;0正常，1删除,默认为0
    */
    private Integer isDel;

    private Integer isAdmin;
    private String agreement;

}
