package com.cmeeting.ad.controller;

import com.cmeeting.ad.service.UserService;
import com.cmeeting.ad.vo.UserVo;
import com.cmeeting.util.IPUtils;
import com.cmeeting.util.R;
import com.cmeeting.ad.vo.ApplicationUserVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("/user")
public class UserController {

    @Autowired
    private UserService userService;

    /**
     * 咨询窗用
     *
     * @param vo
     * @return
     */
    @CrossOrigin
    @PostMapping("/login")
    public R login(@RequestBody @Validated ApplicationUserVO.LoginDecrypt vo, HttpServletRequest request) {
        String ipAddr = IPUtils.getIpAddr(request);
        return userService.login(vo.getAgentId(), vo.getData(), ipAddr);
    }

//    @PostMapping(value = "/auth")
//    public R auth(@Validated @RequestBody UserVo.Auth vo) {
//        return R.ok(userService.auth(vo.getId(), vo.getNick()));
//    }

    @PostMapping(value = "/tokenAuth")
    public R tokenAuth(@Validated @RequestBody ApplicationUserVO.LoginDecrypt vo) {
        try {
            Object token = userService.tokenAuth(vo);
            return R.ok(token);
        } catch (Exception e) {
            return R.error(e.getMessage());
        }
    }

    @PostMapping(value = "/emailAuth")
    public R emailAuth(@Validated @RequestBody UserVo.Auth vo) {
        return R.ok(userService.emailAuth(vo));
    }
}