package com.cmeeting.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.cmeeting.pojo.MeetingInfo;
import com.cmeeting.vo.MeetingInfoVO;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface MeetingInfoService extends IService<MeetingInfo> {
    IPage<MeetingInfo> getPage(MeetingInfoVO vo);

    boolean updateRecordXml(MeetingInfoVO vo);

    boolean regenerateXml(MeetingInfoVO vo);

    /**
     * 统计邮件推送情况
     */
    void statisticsEmail(Integer type, Date startTime, Date endTime, HttpServletResponse response, Map<String, String> map);
    boolean statisticsEmail(String title, Date startTime, Date endTime, OutputStream outputStream, Map<String, String> map);

    List<Map<String, Object>> statisticsEmail(Date startTime, Date endTime, Map<String, String> map);

    /**
     * 统计
     *
     * @param searchValue     查询值
     * @param createTimeStart 起始时间
     * @param createTimeEnd   截止时间
     * @param page
     * @return
     */
    List<Map<String, String>> statistics(String searchValue, Date createTimeStart, Date createTimeEnd, Boolean page);

    /**
     * 导出
     *
     * @param searchValue     搜索值
     * @param createTimeStart 起始时间
     * @param createTimeEnd   截止时间
     * @param response
     */
    void exportRecordTemplateUsingInfo(String searchValue, Date createTimeStart, Date createTimeEnd, HttpServletResponse response);

    int deleteDataAfterThan2Days(String date);
}
