package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.*;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 操作日志
 * @TableName operation_log
 */
@TableName(value ="operation_log")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OperationLog {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 操作页面
     */
    private String location;

    /**
     * 操作记录
     */
    private String operation;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyy-MM-dd HH:mm:ss")
    private Date createTime;
}