package com.cmeeting.vo;

import com.cmeeting.pojo.ModulePermission;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class PermissionVO {

    /**
     * 选择授权页面查询
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CheckList {
        private String search;
        @NotBlank
        private String categoryId;

        @NotNull
        private Integer purpose;
        @NotNull
        private Integer userType;
        private Integer targetId;
    }


    /**
     * 以授权用户/部门查询
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CheckedList {
        /**
         * purpose为0/3时为空，为1时是纪要类型id，2时纪要模板id
         */
        private Long targetId;
        private String search;
        /**
         * 0-授权纪要功能，1-纪要类型分享，2-纪要模板分享，3-用户自己关闭纪要功能
         */
        @NotNull
        private Integer purpose;

    }


}
