package com.cmeeting.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.cmeeting.dto.MeetTypeDto;
import com.cmeeting.dto.RecordTemplateDto;
import com.cmeeting.dto.UserDTO;
import com.cmeeting.pojo.MeetingRecordTemplate;
import com.cmeeting.vo.EditRecordTemplateVo;
import com.cmeeting.vo.RecordTemplateVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface MeetingRecordTemplateService extends IService<MeetingRecordTemplate> {
    /**
     * 管理员可见范围的模板列表
     * @param vo
     * @return
     */
    List<RecordTemplateDto> getRecordTemplateDtoList(RecordTemplateVO vo);

    /**
     * 普通用户查询个人模板列表
     * @param vo
     * @return
     */
    IPage<MeetingRecordTemplate> getPersonalPage(RecordTemplateVO vo);

    /**
     * 上传附件模板
     * @param file
     * @param id
     * @return
     */
    String templateUpload(MultipartFile file,Integer id);

    /**
     * 获取模板授权的人员
     * @return
     */
    List<UserDTO.TemplateAuthorizedUserDTO> selectAuthorizedUsers();

    /**
     * 用户下拉选择的模板列表（权限内）
     * @param vo
     * @return
     */
    List<MeetingRecordTemplate> getSelectList(RecordTemplateVO vo);

    /**
     * 保存模板
     * @param recordTemplateVo 请求参数
     */
    Long save(EditRecordTemplateVo recordTemplateVo);

    /**
     * 更新模板
     * @param recordTemplateVo 模板参数
     */
    void updateById(EditRecordTemplateVo recordTemplateVo);

    /**
     * 启用模板
     * @param id 模板id
     */
    Boolean enable(Long id);

    /**
     * 根据id删除会议模板
     * @param id 模板id
     */
    void delete(Long id);

    /**
     * 获取模板下拉列表
     * @return
     */
    List<RecordTemplateDto> getTemplateSelect();

    /**
     * 根据会议类型和userId获取开启的模板
     * 如果当前会议类型中没有开启的模板，则返回系统通用的已开启的模板
     * @param meetType 会议类型id
     * @param userId   userId
     */
    MeetingRecordTemplate getEnabledRecordTemplate(Long meetType, String userId);

    /**
     * 获取模板列表
     *
     * @param userId           用户id
     * @param parentDeptIdList 部门id列表
     * @param role
     * @return
     */
    List<MeetTypeDto> getMeetTypeList(String userId, List<String> parentDeptIdList, String role);
}
