package com.cmeeting.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class PermissionCheckedDTO implements Serializable {

    private List<Category> categoryList = new ArrayList<>();
    private List<User> userList = new ArrayList<>();

    @Data
    public static class Category{
        private String id;
        private Integer userType;
        private String name;
        private Boolean check = false;

    }

    @Data
    public static class User{
        private String id;
        private Integer userType;
        private String name;
        private String deptName;
        private Boolean check = false;
    }
    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CateOrUser{
        private String id;
        /**
         * 0 部门 / 1 用户
         */
        private Integer type;
        private Integer userType;
        private String name;
        private String deptName;
    }

}
