package com.cmeeting.vo;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Description 会议类型vo
 * @Author zhang kaishi
 * @Date 2025/7/18 9:50
 **/
@Data
public class MeetingTypeVo {

    @NotNull(message = "id不能为空", groups = {UpdateGroup.class, DeleteGroup.class})
    private Long id;

    // 类型名称
    @NotEmpty(message = "name不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String name;
    /**
     * 正则匹配类型
     */
    private String regex;

    // 允许用户在此类型下自定义创建模板，0-不允许，1-允许(默认)
    @Range(min = 0, max = 1, message = "personalPermission只能为0或1", groups = {AddGroup.class, UpdateGroup.class})
    private Integer personalPermission;

    // 授权类型。0-不授权，1-授权给所有人(默认)，2-自定义
    @Range(min = 0, max = 2, message = "authType只能为0或1或2", groups = {AddGroup.class, UpdateGroup.class})
    private Integer authType;

    // 用户id
//    private List<String> userIds;
    private List<AuthVO.Add> authData;

    // 参考类型id
    private Long relId;

    // 类型描述的内容
    @NotEmpty(message = "content不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String content;


    public interface AddGroup{};
    public interface UpdateGroup{};
    public interface DeleteGroup{};
}
