package com.cmeeting.mapper.primary;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.cmeeting.dto.MeetTypeDto;
import com.cmeeting.dto.RecordTemplateDto;
import com.cmeeting.pojo.MeetingRecordTemplate;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;


@Mapper
public interface MeetingRecordTemplateMapper extends BaseMapper<MeetingRecordTemplate> {


    /**
     * 查询授权的模板-会议类型维度
     * @return
     */
    List<MeetTypeDto> selectPermissionTmplInMeetType(@Param("userId") String userId,
                                                           @Param("deptIdList") List<String> deptIdList);

    /**
     * 获取指定授权的模板-纪要模板维度
     * @return
     */
    List<MeetTypeDto> selectPermissionTmpl(@Param("userId") String userId,
                                                 @Param("deptIdList") List<String> deptIdList);

    /**
     * 获取非授权的模板，包括系统通用的和自己创建的
     * @param meetTypeId
     * @return
     */
    List<MeetTypeDto> selectAllTmplWithoutPermission(@Param("meetTypeId") Long meetTypeId,
                                                     @Param("userId") String userId);

    /**
     * 获取模板
     * @return
     */
    List<RecordTemplateDto> selectRecordTemplateDtoList(@Param("type") String type,
                                                        @Param("name") String name,
                                                        @Param("meetingType") String meetingType,
                                                        @Param("createUser") String createUser,
                                                        @Param("startTime") LocalDateTime startTime,
                                                        @Param("endTime") LocalDateTime endTime);



    /**
     * 获取启用的模板
     * @param meetTypeId 会议类型id，允许为空
     * @param userId     userId
     * @return
     */
    MeetingRecordTemplate selectEnabledTemplate(@Param("meetTypeId") Long meetTypeId,
                                                @Param("userId") String userId);

    /**
     * 获取系统通用的启用的模板
     * @return
     */
    MeetTypeDto selectEnabledSystemTemplate();

    /**
     * @param type system 超管 / custom个人
     * @return
     */
    List<MeetTypeDto> selectTemplate(String type);

    List<MeetTypeDto> selectCustomTemplate(String userId);

    int disableSystemExceptId(Long id);
}