package com.cmeeting.mapper.primary;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.cmeeting.pojo.MeetingInfo;
import com.cmeeting.vo.TencentMeetingVO;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Mapper
public interface MeetingInfoMapper extends BaseMapper<MeetingInfo> {
    void batchInsert(@Param("meetingSaveList")List<MeetingInfo> meetingSaveList);

    List<TencentMeetingVO.SimpleMeetingInfo> getAllMeetingIds();

    /**
     * 统计
     *
     * @param startTime
     * @param endTime
     * @param dateList
     * @return
     */
    @MapKey("host_uid")
    List<Map<String, String>> statistics(@Param("startTime") String startTime,
                                         @Param("endTime") String endTime,
                                         @Param("dateList") List<String> dateList);

    int deleteDataAfterThan2Days(@Param("date") String date);


//    List<MeetingInfo> selectList(MeetingInfoVO vo);

}