package com.cmeeting.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author 吕轶伟
 * @date 2024/6/26 下午4:17
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DocResultDto {
    /**
     * 分类id
     */
    private String categoryId;
    /**
     * 分类路径
     */
    private String docPath;
    /**
     * 文档名称
     */
    private String docName;
    /**
     * 文档标题
     */
    private String docTitle;
    /**
     * 文档类型(0:word, 1: excel, 2: ppt, 3: pdf, 4: txt, 5: 用户自建文档)
     */
    private String docType;
    /**
     * 文档内容(针对text文档)
     */
    private String docContent;

    /**
     * 预览地址
     */
    private String previewPath;
    /**
     * 文档状态(0: 启用, 1: 停用)
     */
    private String docStatus;

    private String size;
    /**
     * 同步状态(0: 上传成功, 1: 上传失败, 2: 同步中, 3: 处理中, 4: 同步成功, 5: 同步失败, 6: 用户取消同步)
     */
    private String syncStatus;
    /**
     * 知识库id
     */
    private String libraryId;

    private boolean checked;

    private boolean isSys;

    private List<TagTypeResultDto> tagTypeList;

    /**
     * 主键ID
     */
    private String id;

    /**
     * 0-正常，1-删除
     */
    private boolean isDel;

    /**
     * 用户创建人
     */
    private String createUser;

    /**
     * 更新者
     */
    private String updateUser;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 租户id
     */
    private String tenantId;

    private String parentId;

    private String libraryName;

    private String categoryName;

    private List<RelAttachFileDto> relAttachFiles;

    private RelAttachFileDto sourceFile;

    private String pdfPath;
    private String xlfFilePath;

    private String authorId;

    private String author;
}