package com.cmeeting.util;

/**
 * @author cf
 * @date 2023/7/3下午 1:06
 */

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

@Slf4j
public class SSLUtils {
    /**
     * 忽略https证书验证
     *
     * @return
     */
    public static SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, getTrustManager(), new SecureRandom());
            return sslContext.getSocketFactory();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static TrustManager[] getTrustManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{
                new X509TrustManager() {
                    //检查客户端证书，若不信任该证书抛出异常，咱们自己就是客户端不用检查
                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    //检查服务器的证书，若不信任该证书抛出异常，可以不检查默认都信任
                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    //返回受信任的X509证书数组
                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[]{};
                    }
                }
        };
        return trustAllCerts;
    }

    public static String sendPostByHttps(String url, JSONObject data) {
        log.info("https post: {}", url);
        String result = HttpRequest.post(url)
                .header("Content-Type", "application/json;charset=UTF-8")
                .setSSLSocketFactory(SSLUtils.getSSLSocketFactory())
                .body(data.toJSONString())
                .execute().body();
        return result;
    }

    public static String sendGetByHttps(String url) {
        log.info("https get: {}", url);
        String result = HttpRequest.get(url)
                .setSSLSocketFactory(SSLUtils.getSSLSocketFactory())
                .execute().body();
        return result;
    }
    public static String sendGetByHttpsAndTtimOut(String url) {
        log.info("https get: {}", url);
        String result = HttpRequest.get(url)
                .setSSLSocketFactory(SSLUtils.getSSLSocketFactory())
                .timeout(60000)
                .execute().body();
        return result;
    }

    public static String sendXmlPostByHttps(String url, String data, String apiKey) {
        log.info("Https Xml Post: {}", url);
        log.info("Https Xml body: {}", data);
        return HttpRequest.post(url)
                .header("Content-Type", "text/xml")
                .header("Accept", "application/xml")
                .header("apikey", apiKey)
                .setSSLSocketFactory(SSLUtils.getSSLSocketFactory())
                .body(data).execute().body();
    }

    public static String sendPostByHttps(String url, String data, String apiKey) {
        log.info("Https Url: {}", url);
        log.info("Https body: {}", data);
        String ret = HttpRequest.post(url)
                .header("Content-Type", "application/json")
                .header("apikey", apiKey)
                .setSSLSocketFactory(SSLUtils.getSSLSocketFactory())
                .body(data).execute().body();
        log.info("Https ret: {}", ret);
        return ret;
    }

}

