package com.cmeeting.mapper.primary;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.cmeeting.pojo.SysUserSyncCategory;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

public interface SysUserSyncCategoryMapper extends BaseMapper<SysUserSyncCategory> {
    @Select("<script>" +
            "        SELECT d1.dept_id,d1.name\n" +
            "        FROM sys_user_sync_category d1\n" +
            "                 LEFT JOIN sys_user_sync_category d2 ON d1.parent_id = d2.dept_id\n" +
            "        WHERE d2.dept_id IS NULL \n" +
            "        <if test=\"search != null and search != ''\">\n" +
            "            and d1.name like concat('%', #{search}, '%')\n" +
            "        </if>" +
            "</script>")
    List<SysUserSyncCategory> selectParentIdNoInId(@Param("search") String search);
}
