package com.cmeeting.service;

import com.cmeeting.dto.PermissionCheckedDTO;
import com.cmeeting.pojo.ModulePermission;
import com.baomidou.mybatisplus.extension.service.IService;
import com.cmeeting.vo.AuthVO;
import com.cmeeting.vo.PermissionVO;

import java.util.List;

/**
* @author Administrator
* @description 针对表【module_permission(权限表)】的数据库操作Service
* @createDate 2025-07-17 10:55:32
*/
public interface ModulePermissionService extends IService<ModulePermission> {

    PermissionCheckedDTO permissionList(String search, String categoryId, Integer userType, Integer purpose, Integer targetId, List<String> categoryList, List<String> userList);
    PermissionCheckedDTO permissionList(String search, String categoryId, Integer userType, Integer purpose, List<String> categoryList, List<String> userList);

    List<PermissionCheckedDTO.CateOrUser> checkedList(String search, Integer purpose, Long targetId);

    Boolean auth(List<AuthVO.Add> authData);

    List<PermissionCheckedDTO.User> personalCancelList(String query);

    Boolean personalSwitch(String userId, boolean enable);

    /**
     * 校验权限
     * return为List的时候需要判断relId为all的情况
     */
    List<ModulePermission> checkPermission(List<String> deptIds, String userId);
    List<Long> checkPermission(List<String> deptIds, String userId, Integer purpose);
    Boolean checkAdminPermission(List<String> deptIds, String userId);
    Boolean checkPermission(List<String> deptIds, String userId, Integer purpose, Long targetId);

    Boolean personalStatus(String userId);
}
