package com.cmeeting.pojo;

import com.baomidou.mybatisplus.annotation.*;

import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * meeting内部权限表
 * @TableName module_permission
 */
@TableName(value ="module_permission")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ModulePermission {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 类型，0-分类，1-用户   RecordTemplateConstant
     */
    private Integer type;

    /**
     * 用户类型，2-通讯录，3-超管分享
     */
    private Integer userType;

    /**
     * 0-授权纪要功能，1-纪要类型分享，2-纪要模板分享，3-用户自己关闭纪要功能
     */
    private Integer purpose;

    /**
     * 关联id（分类id或用户id）
     */
    private String relId;

    /**
     * purpose为0/3时为空，为1时是纪要类型id，2时纪要模板id
     */
    private Long targetId;

    /**
     * 
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;
}