package com.cmeeting.ad.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 应用用户配置关联表(ModulePermissions)实体类
 *
 * @author makejava
 * @since 2024-05-11 13:22:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("core_module_permissions")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ModulePermissions implements Serializable {
    private static final long serialVersionUID = 686579698726893795L;
    /**
    * 配置表主键
    */
    private String id;
    /**
    * 0 分类 1用户
    */
    private Integer type;
    /**
    * 0自建 1 应用 2通讯录 3超管分享
    */
    private Integer userType;
    /**
    * 0 角色授权  1应用授权 2文档授权
    */
    private Integer source;
    /**
    * 关联id（分类id或用户id）
    */
    private String relId;
    /**
    * 创建时间
    */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;
    /**
    * 更新时间
    */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
    * 角色id  /应用id /文档id
    */
    private String targetId;

    private String tenantId;

    @TableField(exist = false)
    private String name;
    @TableField(exist = false)
    private String deptName;

}
