package com.cmeeting.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cmeeting.ad.entity.SysUserSync;
import com.cmeeting.mapper.secondary.SysUserSysMapper;
import com.cmeeting.service.SysUserSyncService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Slf4j
public class SysUserSyncServiceImpl extends ServiceImpl<SysUserSysMapper, SysUserSync>  implements SysUserSyncService {

    @Value(value = "${permission.tenantId}")
    private String perTenantId;

    private static Map<String, String> DEPT_MAP = new HashMap<>(12);
    static {
        DEPT_MAP.put("10340", "集团总部");
        DEPT_MAP.put("11683", "中集车辆（集团）股份有限公司");
        DEPT_MAP.put("11080", "中集安瑞科投资控股（深圳）有限公司");
        DEPT_MAP.put("635364", "中集管理培训（深圳）有限公司");
        DEPT_MAP.put("612702", "中集世联达集装箱物流（深圳）有限公司");
        DEPT_MAP.put("661082", "柏坚货柜机械维修（深圳）有限公司");
        DEPT_MAP.put("745168", "中集世联达国际物流有限公司");
        DEPT_MAP.put("766268", "中铁集物流装备有限公司");
        DEPT_MAP.put("698027", "深圳中集同创供应链有限公司");
        DEPT_MAP.put("674199", "中集模块化建筑投资有限公司");
        DEPT_MAP.put("698022", "深圳中集共享后勤服务有限公司");
        DEPT_MAP.put("707436", "深圳市集家美寓公寓管理有限公司");
    }

    @Override
    public String getDeptPathByUserId(String userId) {
        SysUserSync sysUserSync = baseMapper.selectOne(new LambdaQueryWrapper<SysUserSync>()
                .eq(SysUserSync::getTenantId, perTenantId).eq(SysUserSync::getUserId, userId)
                .select(SysUserSync::getDeptId).last("limit 1"));
        String deptId = sysUserSync.getDeptId();
        return getDeptPath("/" + deptId, deptId);
    }

    @Override
    public List<String> getDeptPathByUserIdAndInSet(String userId) {
        List<SysUserSync> sysUserSyncs = baseMapper.selectList(new LambdaQueryWrapper<SysUserSync>()
                .eq(SysUserSync::getTenantId, perTenantId).eq(SysUserSync::getUserId, userId)
                .select(SysUserSync::getDeptId));
        List<String> collect = sysUserSyncs.stream().map(SysUserSync::getDeptId).collect(Collectors.toList());
        List<String> ret = new ArrayList<>();
        for (String s : collect) {
            ret.add(getDeptPath("/" + s, s));
        }
        return ret;
    }

    /**
     * 向上获取某个部门的路径
     * @param deptId
     */
    private String getDeptPath(String deptPath,String deptId) {
        String parentDeptId = baseMapper.getParentDeptId(deptId,perTenantId);
        if(StringUtils.isEmpty(parentDeptId)) return deptPath;

        return getDeptPath("/" + parentDeptId + deptPath, parentDeptId);
    }
}
