package com.cmeeting.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.cmeeting.ad.entity.RobotSecurityUser;
import com.cmeeting.ad.util.SecurityUtil;
import com.cmeeting.dto.UserDTO;
import com.cmeeting.pojo.MeetingInfo;
import com.cmeeting.pojo.MeetingRecordTemplate;
import com.cmeeting.service.MeetingRecordTemplateService;
import com.cmeeting.service.RecordTemplatePermissionService;
import com.cmeeting.util.R;
import com.cmeeting.vo.RecordTemplateVO;
import com.deepoove.poi.XWPFTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * 纪要模板控制层
 */
@RestController
@RequestMapping("/recordTemplate")
public class RecordTemplateController {
    @Autowired
    private MeetingRecordTemplateService recordTemplateService;
    @Resource
    private RecordTemplatePermissionService recordTemplatePermissionService;

    @PostMapping("/create")
    public R create(@RequestBody MeetingRecordTemplate recordTemplate) {
        RobotSecurityUser user = SecurityUtil.getUser();
        System.out.println("RobotSecurityUser:"+user.toString());
        LocalDateTime now = LocalDateTime.now();
        recordTemplate.setCreateTime(now);
        recordTemplate.setUpdateTime(now);
        recordTemplate.setIsDel(Boolean.FALSE);
        recordTemplate.setCreateUser(user.getId());
        recordTemplate.setUpdateUser(user.getId());
        recordTemplate.setCreateUserName(user.getUsername());
        recordTemplate.setUpdateUserName(user.getUsername());
        boolean save = recordTemplateService.save(recordTemplate);
        return R.ok(recordTemplate);
    }

    @PostMapping("/update")
    public R update(@RequestBody MeetingRecordTemplate recordTemplate) {
        RobotSecurityUser user = SecurityUtil.getUser();
        recordTemplate.setUpdateTime(LocalDateTime.now());
        recordTemplate.setUpdateUser(user.getId());
        recordTemplate.setUpdateUserName(user.getUsername());
        boolean save = recordTemplateService.updateById(recordTemplate);
        return R.ok(save);
    }

    @PostMapping("/disable")
    public R disable(@RequestBody MeetingRecordTemplate recordTemplate) {
        boolean save = recordTemplateService.update(
                new LambdaUpdateWrapper<MeetingRecordTemplate>()
                        .eq(MeetingRecordTemplate::getId,recordTemplate.getId())
                        .set(MeetingRecordTemplate::getIsDel,Boolean.TRUE)
        );
        return R.ok(save);
    }

    /**
     * 纪要模板列表，通过type区分为系统模板还是自定义模板
     * @param vo
     * @return
     */
    @PostMapping("/list")
    public R list(@RequestBody RecordTemplateVO vo) {
        IPage<MeetingRecordTemplate> page = recordTemplateService.getPage(vo);
        return R.ok(page);
    }

    /**
     * 用户下拉选择的模板列表（权限内）
     * @param vo
     * @return
     */
    @PostMapping("/selectList")
    public R selectList(@RequestBody RecordTemplateVO vo) {
        List<MeetingRecordTemplate> records = recordTemplateService.getSelectList(vo);
        return R.ok(records);
    }

    /**
     * 普通用户纪要模板，查出有授权的系统模板和个人创建的自定义模板
     * @param vo
     * @return
     */
    @PostMapping("/personalList")
    public R personalList(@RequestBody RecordTemplateVO vo) {
        IPage<MeetingRecordTemplate> page = recordTemplateService.getPersonalPage(vo);
        return R.ok(page);
    }

    @PostMapping("/detail")
    public R detail(@RequestBody RecordTemplateVO vo) {
        MeetingRecordTemplate detail = recordTemplateService.getById(vo.getId());
        return R.ok(detail);
    }

    @PostMapping("/templateUpload")
    public R templateUpload(@RequestParam("file") MultipartFile file,@RequestParam("id") Integer id) {
        String template = recordTemplateService.templateUpload(file, id);
        return R.ok(template);
    }

    /**
     * 模板授权
     * @param vo
     * @return
     */
    @PostMapping("/auth")
    public R auth(@RequestBody RecordTemplateVO.TemplatePermissionVO vo) {
        return R.ok(recordTemplatePermissionService.auth(vo));
    }

    /**
     * 模板已授权列表
     * @param vo
     * @return
     */
    @PostMapping("/authList")
    public R authList(@RequestBody RecordTemplateVO.TemplateAuthVO vo) {
        return R.ok(recordTemplatePermissionService.authList(vo));
    }

    /**
     * 获取模板授权的人员
     * @return
     */
    @PostMapping("/selectAuthorizedUsers")
    public R selectAuthorizedUsers() {
        return R.ok(recordTemplateService.selectAuthorizedUsers());
    }

    /**
     * 模板测试效果
     * @param file 用户自主上传的转录文件
     * @param meetingInstId 历史会议主键id
     * @param id 模板id
     * @return
     */
    @PostMapping("/testGenerate")
    public R testGenerate(@RequestParam(value = "file",required = false) MultipartFile file,
                          @RequestParam(value = "meetingInstId",required = false) Integer meetingInstId,
                          @RequestParam("id") Integer id) {
        return R.ok(recordTemplatePermissionService.testGenerate(file,meetingInstId,id));
    }

    /**
     * 模板测试效果导出纪要
     * @param recordJson 纪要内容json
     * @param meetingInstId 历史会议主键id
     * @param id 模板id
     * @return
     */
    @PostMapping("/testMinutesExport")
    public void testMinutesExport(@RequestParam(value = "recordJson") String recordJson,
                                  @RequestParam(value = "meetingInstId",required = false) Integer meetingInstId,
                                  @RequestParam("id") Integer id,
                                  HttpServletResponse response) {
        recordTemplatePermissionService.testMinutesExport(recordJson,meetingInstId,id,response);
    }
}
